import React, { useEffect } from "react";
import * as Animatable from "react-native-animatable";
import { View, Text } from "react-native";
import { createBottomTabNavigator } from "@react-navigation/bottom-tabs";
import HomeIcon from "../../assets/svgs/tabNaviagtion/homeIcon.svg";
import CategoryIcon from "../../assets/svgs/tabNaviagtion/catrgoryIcon.svg";
import CartIcon from "../../assets/svgs/tabNaviagtion/cartIcon.svg";
import ProfileIcon from "../../assets/svgs/tabNaviagtion/profileIcon.svg";
import Categories from "../../screens/Categories/Categories";
import Cart from "../../screens/ShoppingCart/ShoppingCart";
import Home from "../../screens/Home/Home";
import Profile from "../../screens/Profile/Profile";
import dpr from "../../screens/Utilities/CustomStyleAttribute/dpr";
import { useSelector } from "react-redux";

import PrivateRoute from "./PrivateRoute/PrivateRoute";
import { useDispatch } from "react-redux";
import useAuth from "../../hooks/useAuth";
import rootApiRequest, { authApiRequest } from "../../helper/rootApiRequest";
import useLangTranslation from "../../hooks/useLangTranslation";
import { styles } from "./TabNavigationStyle";
import CustomSVG from "../../src/components/CustomSVG/CustomSVG";

const tabIconHeight = dpr(24);
const tabIconWidth = dpr(20);

const Tab = createBottomTabNavigator();

const TabNavigation = () => {
    const { trans } = useLangTranslation();
    const { access_token } = useAuth();
    const dispatch = useDispatch();
    const {
        cartLoading,
        cart_Data: { cartData },
    } = useSelector((state) => state.cartProductSlice);

    useEffect(() => {
        rootApiRequest(dispatch, access_token);
        if (access_token) {
            authApiRequest(dispatch, access_token);
        }
    }, []);

    return (
        <Tab.Navigator
            screenOptions={{
                tabBarHideOnKeyboard: true,
                headerShown: false,
                tabBarShowLabel: false,
                tabBarStyle: styles.tabBarStyle,
            }}
        >
            <Tab.Screen
                name="Home"
                component={Home}
                options={{
                    tabBarIcon: ({ focused }) => (
                        <View style={styles.singleTabContainer}>
                            <CustomSVG svgIcon={HomeIcon}
                                width={tabIconWidth}
                                height={tabIconHeight}
                                fill={focused ? "#2C2C2C" : "#898989"}
                            />
                            <Text
                                style={styles.tabBarLabel(focused)}
                                numberOfLines={1}
                            >
                                {trans("Home")}
                            </Text>
                        </View>
                    ),
                }}
            />
            <Tab.Screen
                name="Categories"
                component={Categories}
                options={{
                    tabBarIcon: ({ focused }) => (
                        <View style={styles.singleTabContainer}>
                            <CustomSVG svgIcon={CategoryIcon}
                                width={tabIconWidth}
                                height={tabIconHeight}
                                fill={focused ? "#2C2C2C" : "#898989"}
                            />
                            <Text
                                style={styles.tabBarLabel(focused)}
                                numberOfLines={1}
                            >
                                {trans("Categories")}
                            </Text>
                        </View>
                    ),
                }}
            />
            <Tab.Screen
                name="my cart"
                component={Cart}
                options={{
                    tabBarIcon: ({ focused }) => (
                        <View style={styles.singleTabContainer}>
                            <View style={styles.labelArea}>
                                <CustomSVG svgIcon={CartIcon}
                                    width={tabIconWidth}
                                    height={tabIconHeight}
                                    fill={focused ? "#2C2C2C" : "#898989"}
                                />
                                {!cartLoading && cartData?.length > 0 && (
                                    <Animatable.View
                                        animation="zoomIn"
                                        duration={500}
                                        style={styles.label}
                                    >
                                        <Text style={styles.labelText} >
                                            {cartData?.length}
                                        </Text>
                                    </Animatable.View>
                                )}
                            </View>
                            <Text
                                style={styles.tabBarLabel(focused)}
                                numberOfLines={1}
                            >
                                {trans("Cart")}
                            </Text>
                        </View>
                    ),
                }}
            />
            <Tab.Screen
                name="MY ACCOUNT"
                options={{
                    tabBarIcon: ({ focused }) => (
                        <View style={styles.singleTabContainer}>
                            <CustomSVG svgIcon={ProfileIcon}
                                width={tabIconWidth}
                                height={tabIconHeight}
                                fill={focused ? "#2C2C2C" : "#898989"}
                            />
                            <Text
                                style={styles.tabBarLabel(focused)}
                                numberOfLines={1}
                            >
                                {trans("Profile")}
                            </Text>
                        </View>
                    ),
                }}
            >
                {(props) => (
                    <PrivateRoute>
                        <Profile {...props} />
                    </PrivateRoute>
                )}
            </Tab.Screen>
        </Tab.Navigator>
    );
};

export default TabNavigation;
